﻿var offlineActivity = {
    refreshDataTable: function () {
        //extraction.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        $(".h-dailyTracking-table").a4datatable({
            displaySearchBox: false,
            displayColumnSelector: false,
            ajaxAction: a4.getSurveyAction("GetOfflineDailyTracking", "Analyze"),
            ajaxParams: { "filter": currentFilter },
            columns: [
                { "Name": "Date", "Title": resources.Date, "Data": "Date" },
                { "Name": "ReceivedCases", "Title": resources.ReceivedCases, "Data": "ReceivedCases" },
                { "Name": "Appointments", "Title": resources.Appointments, "Data": "Appointments" },
                { "Name": "Completed", "Title": resources.Completed, "Data": "Completed" },
                { "Name": "AvgCompletedHours", "Title": resources.AvgCompletedPerHour, "Data": "AvgCompletedHours" },
                { "Name": "ToDo", "Title": resources.Todo, "Data": "ToDo" }
            ]
        });

        $(".h-userTracking-table").a4datatable({
            displaySearchBox: false,
            displayColumnSelector: false,
            ajaxAction: a4.getSurveyAction("GetOfflineUserTracking", "Analyze"),
            ajaxParams: { "filter": currentFilter },
            columns: [
                { "Name": "UserName", "Title": resources.User, "Data": "UserName" },
                { "Name": "ReceivedCases", "Title": resources.ReceivedCases, "Data": "ReceivedCases" },
                { "Name": "Appointments", "Title": resources.Appointments, "Data": "Appointments" },
                { "Name": "Completed", "Title": resources.Completed, "Data": "Completed" },
                { "Name": "AvgCompletionTime", "Title": resources.AvgCompletionTime, "Data": "AvgCompletionTimeFormatted" },
                { "Name": "AvgCompletedPerHour", "Title": resources.AvgCompletedPerHour, "Data": "AvgCompletedPerHour" },
                { "Name": "AvgCompletedPerDay", "Title": resources.AvgCompletedPerDay, "Data": "AvgCompletedPerDay" }
            ]
        });
    },
    bindEvents: function () {
        $(".v-reportFilter").each(function () {
            var currentFilter = $(this);
            var statusSelector = $(".h-statusSelector", currentFilter);

            $(".button", statusSelector).click(function () {
                $(".button").removeClass("selected");
                $(this).addClass("selected");

                var selectedVal = $(this).attr("data-value");
                $("input[type=hidden]", statusSelector).val(selectedVal);
                if (selectedVal != "Custom") {
                    var form = $("form");
                    a4.appendAntiForgeryToken(form);
                    form.submit();
                }
                else {
                    $(".v-custom", currentFilter).show();
                    $("#Filter_StartDateFilter", currentFilter).val("");
                    $("#Filter_EndDateFilter", currentFilter).val("");
                }
            });

            $(".h-applyFilter", currentFilter).click(function () {
                var form = $("form");
                a4.appendAntiForgeryToken(form);
                form.submit();
            });
        });

        $(".h-lazyLoad").lazyLoad();
        $(".h-chartTypeSelector").hide();

        $(".h-datepicker").datetimepicker();
        $("#ui-datepicker-div:visible").hide();
        $(".calendarIcon:not(.disabled)").click(function () {
            $("input.hasDatepicker", $(this).parent()).datepicker('show');
        });
    },
}

$(document).ready(function () {
    if ($(".analyze-offlineActivity").length > 0) {
        offlineActivity.initializeDataTable();
        offlineActivity.bindEvents();
    }
});